using System;
using System.Collections.Generic;

[Serializable]
public class SensorData
{
    public string machineId;
    public string sensorType;
    public float value;
    public string unit;
    public DateTime timestamp;
}

[Serializable]
public class FuzzyLogicData
{
    public List<MachineData> priorityList;
}

[Serializable]
public class MachineData
{
    public string machineId;
    public string priority;
    public float score;

    public override string ToString()
    {
        return $"Machine ID: {machineId}, Priority: {priority}, Score: {score}";
    }
}

